<?php
require_once '../config.php';
require_once '../functions.php';

// گرفتن سفارش‌های پرداخت شده و غیر تکمیل شده
$stmt = $db->prepare("SELECT * FROM orders WHERE status = 'paid' AND process_status != 'تکمیل شده' ORDER BY id DESC");
$stmt->execute();
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

// تابع برای تعیین رنگ وضعیت
function getStatusClass($status) {
    switch ($status) {
        case 'در انتظار بررسی':
            return 'text-warning'; // زرد/نارنجی
        case 'در حال بررسی':
            return 'text-success'; // سبز
        default:
            return 'text-dark'; // پیش‌فرض
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>سفارش‌های فعال</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container my-4 d-md-none d-lg-block">

    <!-- هدر فقط برای دسکتاپ/تبلت بزرگ -->
    <div class="d-none d-md-flex justify-content-between align-items-center mb-3">
        <h4>سفارش‌های فعال</h4>
        <a href="admin_orders_completed.php" class="btn btn-success">سفارش‌های تکمیل شده</a>
    </div>

    <!-- جدول کامل فقط برای دستگاه‌های بزرگتر از تبلت -->
    <div class="table-responsive d-none d-md-block">
        <table class="table table-bordered table-striped text-center align-middle">
            <thead class="table-light">
                <tr>
                    <th>شماره سفارش</th>
                    <th>کد پیگیری</th>
                    <th>نام مشتری</th>
                    <th>تلفن</th>
                    <th>وضعیت پردازش</th>
                    <th>جزئیات</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($orders as $o): 
                $user = json_decode($o['user_snapshot'], true);
            ?>
                <tr>
                    <td>#<?= $o['id'] ?></td>
                    <td><?= $o['ref_id'] ?></td>
                    <td><?= $user['name'] ?></td>
                    <td><?= $user['phone'] ?></td>
                    <td class="<?= getStatusClass($o['process_status']) ?>">
                        <?= $o['process_status'] ?>
                    </td>
                    <td>
                        <a href="admin_order_details.php?order_id=<?= $o['id'] ?>" 
                           class="btn btn-primary btn-sm"
                           target="_blank"
                           onclick="setTimeout(() => location.reload(), 500)">مشاهده جزئیات</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
    
<div class="mx-3 my-4 d-lg-none d-xl-block d-xl-none d-xxl-block d-xxl-none">
    <!-- هدر فقط برای دسکتاپ/تبلت بزرگ -->
    <div class="d-none d-md-flex justify-content-between align-items-center mb-3">
        <h4 class="fs-3">سفارش‌های فعال</h4>
        <a href="admin_orders_completed.php" class="btn btn-success fs-3">سفارش‌های تکمیل شده</a>
    </div>

    <!-- جدول کامل فقط برای دستگاه‌های بزرگتر از تبلت -->
    <div class="table-responsive d-none d-md-block">
        <table class="table table-bordered table-striped text-center align-middle">
            <thead class="table-light">
                <tr>
                    <th class="fs-3">شماره سفارش</th>
                    <th class="fs-3">وضعیت پردازش</th>
                    <th class="fs-3">جزئیات</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($orders as $o): 
                $user = json_decode($o['user_snapshot'], true);
            ?>
                <tr>
                    <td class="fs-3">#<?= $o['id'] ?></td>
                    <td class="fs-3 <?= getStatusClass($o['process_status']) ?>">
                        <?= $o['process_status'] ?>
                    </td>
                    <td>
                        <a href="admin_order_details.php?order_id=<?= $o['id'] ?>" 
                           class="btn btn-primary btn-sm fs-3"
                           target="_blank"
                           onclick="setTimeout(() => location.reload(), 500)">مشاهده جزئیات</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
</div>
</body>
</html>