<?php
require_once 'functions.php';
require_once 'config.php'; // شامل تنظیمات DB، ZARINPAL_MERCHANT_ID و TOKEN تلگرام

try {
    // گرفتن پارامترها از زرین‌پال
    $orderId   = $_GET['order_id'] ?? null;
    $authority = $_GET['Authority'] ?? null;
    $status    = $_GET['Status'] ?? null;

    if (!$authority || !$orderId) {
        exit('پارامتر ناقص است.');
    }

    // بازیابی سفارش از دیتابیس
    $stmt = $db->prepare("SELECT * FROM orders WHERE id = ? LIMIT 1");
    $stmt->execute([$orderId]);
    $order = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$order) {
        exit('سفارش یافت نشد.');
    }

    // اگر کاربر پرداخت رو لغو کرده باشد
    if ($status !== 'OK') {
        $db->prepare("UPDATE orders SET status='canceled' WHERE id=?")->execute([$orderId]);
        sendMessage($order['telegram_id'], "❌ پرداخت لغو شد.\nشماره سفارش: #$orderId");
        
        sendMessage($chat_id, "منوی اصلی:", getMainMenu());

        echoPage(false, null, $orderId, "پرداخت توسط کاربر لغو شد.");
        exit;
    }

    // درخواست تایید تراکنش به زرین‌پال
    $verifyData = [
        "merchant_id" => ZARINPAL_MERCHANT_ID,
        "amount"      => (int)$order['amount'], // حتماً عدد صحیح
        "authority"   => $authority
    ];

    $ch = curl_init("https://api.zarinpal.com/pg/v4/payment/verify.json");
    curl_setopt($ch, CURLOPT_USERAGENT, "ZarinPal Rest Api v4");
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($verifyData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
    $result = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($result, true);
    $data   = $result['data'] ?? null;
    
        // اگر قبلاً paid شده باشه، دیگه عملیات تکرار نشه
    if ($order['status'] === 'paid') {
        echoPage(true, $order['ref_id'], $orderId);
        exit;
    }

    // کد 100 = موفق، کد 101 = موفق قبلی
    if ($data && ($data['code'] == 100 || $data['code'] == 101)) {
        $db->prepare("UPDATE orders SET status='paid', ref_id=?, paid_at=NOW() WHERE id=?")
           ->execute([$data['ref_id'], $orderId]);

        // ذخیره جزئیات محصولات خریداری‌شده
        $items = json_decode($order['items_snapshot'], true);
        if ($items) {
            foreach ($items as $it) {
                $stmt = $db->prepare("INSERT INTO order_items 
                    (order_id, product_id, product_name, color, size, price, quantity) 
                    VALUES (?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([
                    $orderId,
                    $it['product_id'],
                    $it['product_name'],
                    $it['color'],
                    $it['size'],
                    $it['price'],
                    $it['quantity']
                ]);

                // 🔽 کاهش موجودی در API اصلی
                $resp = decreaseStock($it['variation_id'], $it['quantity']);
                if (!$resp || $resp['Code'] != 1) {
                    logToFile("❌ خطا در کاهش موجودی برای variation={$it['variation_id']} - response=" . print_r($resp, true));
                }
            }
        }

        // حذف سبد خرید کاربر
        $db->prepare("DELETE FROM cart WHERE telegram_id = ?")->execute([$order['telegram_id']]);

        // ارسال پیام به کاربر در تلگرام
        sendMessage($order['telegram_id'], 
            "✅ پرداخت با موفقیت انجام شد.\n" .
            "شماره سفارش: #$orderId\n" .
            "کد پیگیری زرین‌پال: {$data['ref_id']}"
            , getMainMenu()
        );
        // 📢 ارسال پیام اعلان به ادمین
        $admin_chat_id = ADMIN_CHAT_ID; // از config.php
        sendMessage($admin_chat_id,
            "📢 *سفارش جدید ثبت شد*\n\n" .
            "👤 کاربر: {$order['telegram_id']}\n" .
            "🛍 شماره سفارش: #$orderId\n" .
            "💳 مبلغ: " . number_format($order['amount']) . " تومان\n" .
            "🔢 کد پیگیری: {$data['ref_id']}",
            null,
            "Markdown"
        );

        
        sendMessage($chat_id, "منوی اصلی:", getMainMenu());

        // نمایش صفحه موفق
        echoPage(true, $data['ref_id'], $orderId);

    } else {
        $db->prepare("UPDATE orders SET status='failed' WHERE id=?")->execute([$orderId]);

        $errorMsg = $data['message'] ?? 'علت نامشخص';
        sendMessage($order['telegram_id'], 
            "⚠️ پرداخت ناموفق بود.\n" .
            "شماره سفارش: #$orderId\n" .
            "کد خطا: " . ($data['code'] ?? 'نامشخص')
        );

        // نمایش صفحه ناموفق
        echoPage(false, null, $orderId, $errorMsg);
    }

} catch (Throwable $e) {
    sendMessage($order['telegram_id'] ?? null, "⚠️ خطای داخلی: " . $e->getMessage());
    exit("خطا: " . $e->getMessage());
}

// تابع نمایش صفحه HTML
// تابع نمایش صفحه HTML
function echoPage($success, $refId = null, $orderId = null, $reason = null) {
    $paid_at = date('Y-m-d H:i:s');
    echo "
    <!DOCTYPE html>
    <html lang='fa'>
    <head>
    <meta charset='UTF-8'>
    <title>نتیجه پرداخت</title>
    <style>
    body {
        font-family: tahoma, sans-serif;
        direction: rtl;
        background-color: #f9f9f9;
    }
    .result-box {
        max-width: 500px;
        margin: 100px auto;
        padding: 20px;
        border-radius: 8px;
        text-align: center;
    }
    .success {
        background-color: #d4edda;
        border: 1px solid #28a745;
        color: #155724;
    }
    .failed {
        background-color: #fff3cd;
        border: 1px solid #ffc107;
        color: #856404;
    }
    .result-box h1 {
        font-weight: bold;
        margin-bottom: 10px;
    }
    .result-box p {
        margin: 5px 0;
        font-size: 14px;
    }
    </style>
    <script>
        // بعد از 10 ثانیه صفحه بسته شود
        setTimeout(function() {
            window.close();
        }, 10000);
    </script>
    </head>
    <body>
    ";

    if ($success) {
        echo "
        <div class='result-box success'>
            <h1>عملیات با موفقیت انجام شد</h1>
            <h4>سفارش شما ثبت شد</h4>
            <h4>کد پیگیری: {$refId}</h4>
            <h4>شماره سفارش: #{$orderId}</h4>
            <h4>تاریخ پرداخت: {$paid_at}</h4>
        </div>
        ";
    } else {
        echo "
        <div class='result-box failed'>
            <h1>عملیات ناموفق بود</h1>
            <h4>{$reason}</h4>
        </div>
        ";
    }

    echo "</body></html>";
}

