<?php
// تست افزایش/کاهش موجودی برای یک محصول
require_once 'config.php'; // شامل تعریف API_BASE و BOT_STOCK_TOKEN

function updateStock($variationId, $quantity) {
    $url = API_BASE . "Bot/Stock/" . $variationId;

    $opts = [
        'http' => [
            'method'  => 'POST',
            'header'  => "Content-Type: application/json\r\nX-Bot-Token: " . BOT_STOCK_TOKEN,
            'content' => json_encode($quantity)
        ]
    ];

    $context = stream_context_create($opts);
    $result = file_get_contents($url, false, $context);

    return json_decode($result, true);
}

// 🔽 اینجا آیدی و تعداد رو تست می‌زنیم
$variationId = 14890; // آیدی واریانت محصول (Variation ID)
$quantity    = 6;   // تعدادی که میخوای اضافه بشه

$response = updateStock($variationId, $quantity);

echo "<pre>";
print_r($response);
echo "</pre>";
