<?php
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../functions.php';

$orderId = $_GET['order_id'] ?? null;
if (!$orderId) {
    exit("شماره سفارش نامعتبر است.");
}

// گرفتن سفارش
$stmt = $db->prepare("SELECT * FROM orders WHERE id = ? LIMIT 1");
$stmt->execute([$orderId]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    exit("سفارش یافت نشد.");
}

if ($order['process_status'] === 'در انتظار بررسی') {
    $stmt = $db->prepare("UPDATE orders SET process_status = 'در حال بررسی' WHERE id = ?");
    $stmt->execute([$orderId]);
    $order['process_status'] = 'در حال بررسی';
}

// گرفتن آیتم‌ها
$stmt = $db->prepare("SELECT * FROM order_items WHERE order_id = ?");
$stmt->execute([$orderId]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

$user = json_decode($order['user_snapshot'], true);
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>جزئیات سفارش <?= $orderId ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<style>
    .icon-circle {
        width: 22px;
        height: 22px;
        border: 2px solid #555;
        border-radius: 50%;
        display: inline-block;
        position: relative;
        cursor: pointer;
    }
    .icon-circle.checked {
        background-color: #198754;
        border-color: #198754;
    }
    .icon-circle.checked::after {
        content: '✔';
        color: white;
        font-size: 14px;
        position: absolute;
        top: -2px;
        left: 4px;
    }
    .tr-completed {
        text-decoration: line-through;
        color: gray;
    }
</style>
<script>
function toggleSelection(itemId) {
    fetch('toggle_item_selection.php?id=' + itemId)
    .then(response => response.text())
    .then(data => {
        const row = document.getElementById('row-' + itemId);
        const circle = document.getElementById('circle-' + itemId);
        if (circle.classList.contains('checked')) {
            circle.classList.remove('checked');
            row.classList.remove('tr-completed');
        } else {
            circle.classList.add('checked');
            row.classList.add('tr-completed');
        }
    });
}
</script>
</head>
<body class="bg-light">

<div class="container my-4 d-md-none d-lg-block">

    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h2 class="card-title mb-3">جزئیات سفارش #<?= $orderId ?></h2>
            <ul class="list-unstyled">
                <li><strong>نام مشتری:</strong> <?= htmlspecialchars($user['name'] ?? '') ?></li>
                <li><strong>تلفن:</strong> <?= htmlspecialchars($user['phone'] ?? '') ?></li>
                <li><strong>آدرس:</strong> <?= htmlspecialchars($user['address'] ?? '') ?></li>
                <li><strong>کد پستی:</strong> <?= htmlspecialchars($user['postal_code'] ?? '') ?></li>
                <li><strong>کد پیگیری زرین‌پال:</strong> <?= htmlspecialchars($order['ref_id']) ?></li>
                <li><strong>تاریخ پرداخت:</strong> <?= htmlspecialchars($order['paid_at']) ?></li>
            </ul>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <h3 class="mb-3">محصولات سفارش</h3>
            <div class="table-responsive">
                <table class="table table-bordered align-middle text-center">
                    <thead class="table-light">
                        <tr>
                            <th>کد محصول</th>
                            <th>نام محصول</th>
                            <th>رنگ</th>
                            <th>سایز</th>
                            <th>قیمت</th>
                            <th>تعداد</th>
                            <th>انتخاب</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($items as $item): ?>
                        <tr id="row-<?= $item['id'] ?>" class="<?= $item['selected'] ? 'tr-completed' : '' ?>">
                            <td><?= htmlspecialchars($item['product_id']) ?></td>
                            <td><?= htmlspecialchars($item['product_name']) ?></td>
                            <td><?= htmlspecialchars($item['color']) ?></td>
                            <td><?= htmlspecialchars($item['size']) ?></td>
                            <td><?= number_format($item['price']) ?> تومان</td>
                            <td><?= htmlspecialchars($item['quantity']) ?></td>
                            <td>
                                <span 
                                    id="circle-<?= $item['id'] ?>" 
                                    class="icon-circle <?= $item['selected'] ? 'checked' : '' ?>" 
                                    onclick="toggleSelection(<?= $item['id'] ?>)">
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-between mt-3">
                <a href="complete_order.php?order_id=<?= $orderId ?>" class="btn btn-success">تکمیل سفارش</a>
                <a href="https://tootfarangisgallery.ir/bot/admin/admin_orders.php" class="btn btn-danger">بازگشت</a>
            </div>
        </div>
    </div>

</div>

<!-- small screen -->
<div class="d-lg-none d-xl-block d-xl-none d-xxl-block d-xxl-none my-4 mx-3">

    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h2 class="card-title mb-3 fs-3 px-2 text-primary">جزئیات سفارش <?= $orderId ?></h2>
            <ul class="list-unstyled d-flex justify-content-between fs-3">
                <li><strong>نام مشتری:</strong> <?= htmlspecialchars($user['name'] ?? '') ?></li>
                <li><strong>تلفن:</strong> <?= htmlspecialchars($user['phone'] ?? '') ?></li>
                <li><strong>کد پستی:</strong> <?= htmlspecialchars($user['postal_code'] ?? '') ?></li>
                
            </ul>
            <ul class="list-unstyled fs-3">
                <li><strong>آدرس:</strong> <?= htmlspecialchars($user['address'] ?? '') ?></li>
                <li><strong>کد پیگیری زرین‌پال:</strong> <?= htmlspecialchars($order['ref_id']) ?></li>
                <li><strong>تاریخ پرداخت:</strong> <?= htmlspecialchars($order['paid_at']) ?></li>
            </ul>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <h3 class="mb-3 fs-3">محصولات سفارش</h3>
            <div class="table-responsive">
                <table class="table table-bordered align-middle text-center">
                    <thead class="table-light">
                        <tr>
                            <th class="fs-3">کد محصول</th>
                            <th class="fs-3">نام محصول</th>
                            <th class="fs-3">رنگ</th>
                            <th class="fs-3">سایز</th>
                            <th class="fs-3">تعداد</th>
                            <th class="fs-3">انتخاب</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($items as $item): ?>
                        <tr id="row-<?= $item['id'] ?>" class="<?= $item['selected'] ? 'tr-completed' : '' ?>">
                            <td class="fs-3"><?= htmlspecialchars($item['product_id']) ?></td>
                            <td class="fs-3"><?= htmlspecialchars($item['product_name']) ?></td>
                            <td class="fs-3"><?= htmlspecialchars($item['color']) ?></td>
                            <td class="fs-3"><?= htmlspecialchars($item['size']) ?></td>
                            <td class="fs-3"><?= htmlspecialchars($item['quantity']) ?></td>
                            <td class="fs-3">
                                <span 
                                    id="circle-<?= $item['id'] ?>" 
                                    class="icon-circle <?= $item['selected'] ? 'checked' : '' ?>" 
                                    onclick="toggleSelection(<?= $item['id'] ?>)">
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-between mt-3">
                <a href="complete_order.php?order_id=<?= $orderId ?>" class="btn btn-success fs-3">تکمیل سفارش</a>
                <a href="https://tootfarangisgallery.ir/bot/admin/admin_orders.php" class="btn btn-danger fs-3">بازگشت</a>
            </div>
        </div>
    </div>

</div>

</body>
</html>
