<?php
require_once '../config.php';
require_once '../functions.php';

// گرفتن سفارش‌های پرداخت شده و تکمیل شده
$stmt = $db->prepare("SELECT * FROM orders WHERE status = 'paid' AND process_status = 'تکمیل شده' ORDER BY id DESC");
$stmt->execute();
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>سفارش‌های تکمیل شده</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container my-4 d-md-none d-lg-block">

    <!-- هدر -->
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="mb-0">سفارش‌های تکمیل شده</h4>
        <a href="admin_orders.php" class="btn btn-primary">بازگشت به سفارش‌های فعال</a>
    </div>

    <!-- جدول -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped text-center align-middle">
            <thead class="table-light">
                <tr>
                    <th>شماره سفارش</th>
                    <th>کد پیگیری</th>
                    <th>نام مشتری</th>
                    <th>تلفن</th>
                    <th>عملیات</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($orders as $o): 
                $user = json_decode($o['user_snapshot'], true);
            ?>
                <tr>
                    <td>#<?= $o['id'] ?></td>
                    <td><?= $o['ref_id'] ?></td>
                    <td><?= $user['name'] ?></td>
                    <td><?= $user['phone'] ?></td>
                    <td>
                        <a href="restore_order.php?order_id=<?= $o['id'] ?>" class="btn btn-danger btn-sm">
                            بازگرداندن
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>

</div>

<div class="mx-3 my-4 d-lg-none d-xl-block d-xl-none d-xxl-block d-xxl-none">
     <!-- هدر -->
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="mb-0 fs-3">سفارش‌های تکمیل شده</h4>
        <a href="admin_orders.php" class="btn btn-primary fs-3">بازگشت به سفارش‌های فعال</a>
    </div>

    <!-- جدول -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped text-center align-middle">
            <thead class="table-light">
                <tr>
                    <th class="fs-3">شماره سفارش</th>
                    <th class="fs-3">کد پیگیری</th>
                    <th class="fs-3">عملیات</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($orders as $o): 
                $user = json_decode($o['user_snapshot'], true);
            ?>
                <tr>
                    <td class="fs-3">#<?= $o['id'] ?></td>
                    <td class="fs-3"><?= $o['ref_id'] ?></td>
                    <td class="fs-3">
                        <a href="restore_order.php?order_id=<?= $o['id'] ?>" class="btn btn-danger btn-sm fs-3">
                            بازگرداندن
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

</body>
</html>
