<?php
// دیباگ فعال
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/../db.php';

$itemId = $_GET['id'] ?? null;

// بررسی مقدار ورودی
if (!$itemId) {
    echo "❌ no_id — مقدار itemId دریافت نشد";
    exit;
}

// چک کنیم که رکورد وجود دارد یا نه
$stmt = $db->prepare("SELECT selected FROM order_items WHERE id = ?");
$stmt->execute([$itemId]);
$item = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$item) {
    echo "❌ item_not_found — محصول با این ID پیدا نشد: " . htmlspecialchars($itemId);
    exit;
}

// برعکس کردن مقدار selected
$newStatus = $item['selected'] ? 0 : 1;

$update = $db->prepare("UPDATE order_items SET selected = ? WHERE id = ?");
if ($update->execute([$newStatus, $itemId])) {
    echo "✅ updated — selected=" . $newStatus;
} else {
    echo "❌ update_failed — خطا در اجرای کوئری";
}
