<?php
ini_set('display_errors', 0);
error_reporting(0);

require_once 'functions.php';

$update = json_decode(file_get_contents("php://input"), true);
$message = $update['message'] ?? null;
$callback = $update['callback_query'] ?? null;

if ($message) {
    $chat_id = $message['chat']['id'];
    $text = trim($message['text'] ?? '');
    logToFile("User sent text: [" . $text . "]");

    $user = getUser($chat_id);
    $state = getUserState($chat_id);

    if (!$user) {
        $stmt = $db->prepare("INSERT INTO users (telegram_id) VALUES (?)");
        $stmt->execute([$chat_id]);
        $user = getUser($chat_id);
    }

    if (preg_match("/^(.+) - (\d{11}) - (.+) - (\d{10})$/u", $text, $matches)) {
        $stmt = $db->prepare("UPDATE users SET name = ?, phone = ?, address = ?, postal_code = ?, is_completed = 1 WHERE telegram_id = ?");
        $stmt->execute([$matches[1], $matches[2], $matches[3], $matches[4], $chat_id]);
        sendMessage($chat_id, "مشخصات شما با موفقیت ذخیره شد ✅");
        return;
    }
    
    // بررسی اینکه آیا استارت با پارامتر محصول است
    if (strpos($text, '/start product_') === 0) {
        $product_id = str_replace('/start product_', '', $text);
    
        $productInfo = getProductById($product_id);
        $details = getProductDetails($product_id);
    
        // عکس محصول
        $photo = '';
        foreach ($details as $v) {
            if (!empty($v['Image'])) {
                $photo = "https://tootfarangi.co" . $v['Image'];
                break;
            }
        }
    
        if (!$photo) {
            sendMessage($chat_id, "❌ تصویری برای این محصول یافت نشد.");
            return;
        }
    
        // آماده‌سازی کپشن
        $caption = "<b>{$productInfo['Name']}</b>\n\n";
        if (!empty($productInfo['Description'])) {
            $caption .= "🔹 توضیحات: " . cleanDescription($productInfo['Description']) . "\n\n";
        }
    
        // ساخت کیبورد انتخاب رنگ و سایز یا سفارش
        $keyboard = [
            'inline_keyboard' => [
                [['text' => '🛍️ افزودن به سبد خرید', 'callback_data' => "addToCart_{$product_id}"]]
            ]
        ];
    
        sendPhoto($chat_id, $photo, $caption, $keyboard);
        return; // جلوگیری از اجرای بقیه‌ی کد
    }

    
    if ($text == "🔙 بازگشت") {
        if ($state && $state['current_state'] == 'options_selected') {
            // برگشت به انتخاب سایز
            $colorSizesMap = json_decode($state['temp_colors'], true);
            $selected_color = $state['selected_color'];
            $sizes = $colorSizesMap[$selected_color] ?? [];
    
            $keyboard = array_chunk($sizes, 2);
            $keyboard[] = [["text" => "🔙 بازگشت"]];
            setUserState($chat_id, 'select_size', $state['last_product_id'], json_encode($colorSizesMap));
    
            sendMessage($chat_id, "رنگ '$selected_color' انتخاب شد. حالا سایز رو انتخاب کنید:", [
                'keyboard' => $keyboard,
                'resize_keyboard' => true
            ]);
        }
        elseif ($state && $state['current_state'] == 'select_size') {
            // برگشت به انتخاب رنگ
            $colorSizesMap = json_decode($state['temp_colors'], true);
            $colors = array_keys($colorSizesMap);
            $keyboard = array_chunk($colors, 2);
            $keyboard[] = [["text" => "🔙 بازگشت"]];
            setUserState($chat_id, 'select_color', $state['last_product_id'], json_encode($colorSizesMap));
    
            sendMessage($chat_id, "لطفاً رنگ مورد نظر را انتخاب کنید:", [
                'keyboard' => $keyboard,
                'resize_keyboard' => true
            ]);
        }
        elseif ($state && $state['current_state'] == 'select_color') {
            // برگشت به منوی اصلی یا لیست محصولات
            sendMessage($chat_id, "به منوی اصلی برگشتی ✅", getMainMenu());
            clearUserState($chat_id);
        }
        return;
    }




    // 🎨 انتخاب رنگ
    if ($state && $state['current_state'] == 'select_color') {
        $colorSizesMap = json_decode($state['temp_colors'], true);
        if (isset($colorSizesMap[$text])) {
            updateUserStateField($chat_id, 'selected_color', $text);
            $sizes = $colorSizesMap[$text];
    
            if (empty($sizes)) {
                // محصول سایز نداره → مستقیم برو به مرحله بعد
                updateUserStateField($chat_id, 'selected_size', '');
                setUserState($chat_id, 'options_selected', $state['last_product_id'], json_encode($colorSizesMap));
                sendMessage($chat_id, "رنگ '$text' انتخاب شد. این محصول سایز ندارد. حالا محصول رو به سبد خرید اضافه کن:", [
                    'keyboard' => [['افزودن به سبد خرید'], ['🔙 بازگشت']],
                    'resize_keyboard' => true
                ]);
            } else {
                // حالت انتخاب سایز
                setUserState($chat_id, 'select_size', $state['last_product_id'], json_encode($colorSizesMap));
                $keyboard = array_chunk($sizes, 2);
                $keyboard[] = ["🔙 بازگشت"];
                sendMessage($chat_id, "رنگ '$text' انتخاب شد. حالا سایز رو انتخاب کنید:", [
                    'keyboard' => $keyboard,
                    'resize_keyboard' => true
                ]);
            }
        }
        return;
    }
    
    
    // 📏 انتخاب سایز
    if ($state && $state['current_state'] == 'select_size') {
        $colorSizesMap = json_decode($state['temp_colors'], true);
        $selected_color = $state['selected_color'];
        if (isset($colorSizesMap[$selected_color]) && in_array($text, $colorSizesMap[$selected_color])) {
            updateUserStateField($chat_id, 'selected_size', $text);
            setUserState($chat_id, 'options_selected', $state['last_product_id'], json_encode($colorSizesMap));
            sendMessage($chat_id, "سایز '$text' انتخاب شد. حالا محصول رو به سبد خرید اضافه کن:", [
                'keyboard' => [['افزودن به سبد خرید'], ['🔙 بازگشت']],
                'resize_keyboard' => true
            ]);
        }
        return;
    }
    
    
    // ✅ افزودن به سبد خرید
    if ($state && $state['current_state'] == 'options_selected' && $text == 'افزودن به سبد خرید') {
        $variations = getProductDetails($state['last_product_id']);
        $variation = findVariation($variations, $state['selected_color'], $state['selected_size']);
    
        $count = isset($variation['count']) ? $variation['count'] : (isset($variation['Count']) ? $variation['Count'] : 0);
        if (!$variation || $count <= 0) {
            sendMessage($chat_id, "این ترکیب رنگ/سایز موجود نیست ❌");
            return;
        }
    
        // گرفتن قیمت
        $price = isset($variation['DiscountPrice']) && $variation['DiscountPrice'] > 0 
            ? $variation['DiscountPrice'] 
            : $variation['Price'];
    
        $product_name = getProductById($state['last_product_id'])['Name'] ?? 'محصول';
    
        // متن پیام تأیید
        $msg = "آیا مطمئنید که محصول:\n"
             . "<b>$product_name</b>\n"
             . "با رنگ: <b>{$state['selected_color']}</b>\n"
             . "و سایز: <b>{$state['selected_size']}</b>\n"
             . "قیمت: <b>" . number_format($price) . " تومان</b>\n"
             . "به سبد خرید شما اضافه شود؟";
    
        $keyboard = [
            'inline_keyboard' => [
                [['text' => 'بله ✅', 'callback_data' => 'confirm_add']],
                [['text' => 'خیر ❌', 'callback_data' => 'cancel_add']]
            ]
        ];
    
        sendMessage($chat_id, $msg, $keyboard);
        return;
    }

	
    
    // اگر کاربر در هر مرحله از ثبت مشخصات بخواهد انصراف بده
    if ($text === "انصراف" && $state && in_array($state['current_state'], ['fill_name', 'fill_phone', 'fill_address', 'fill_postal', 'enter_name'])) {
        clearUserState($chat_id);
        sendMessage($chat_id, "فرآیند ثبت مشخصات لغو شد.", getMainMenu());
        return;
    }
    
    if ($text === "انصراف" && $state && in_array($state['current_state'], ['fill_name_payment', 'fill_phone_payment', 'fill_address_payment', 'fill_postal_payment', 'enter_name'])) {
        clearUserState($chat_id);
        sendMessage($chat_id, "فرآیند ثبت مشخصات لغو شد.", getCartMenu());
        return;
    }
    
    // مرحله نام
    if ($state && in_array($state['current_state'], ['fill_name','fill_name_payment'])) {
        $name = trim($text);
        if (mb_strlen($name, 'UTF-8') < 3) {
            sendMessage($chat_id, "❌ نام واردشده معتبر نیست. حداقل ۳ کاراکتر.\nلطفاً دوباره وارد کنید:", getCancelMenu());
            return;
        }
        upsertUserField($chat_id, 'name', $name);
    
        setUserState($chat_id, $state['current_state']==='fill_name_payment' ? 'fill_phone_payment' : 'fill_phone');
        sendMessage($chat_id, "✅ نام ثبت شد.\nحالا <b>شماره موبایل</b> را وارد کنید:", getCancelMenu());
        return;
    }
    
    // مرحله تلفن
    if ($state && in_array($state['current_state'], ['fill_phone','fill_phone_payment'])) {
        $phone = faToEnNumbers($text);
        $phone = preg_replace('/\D+/', '', $phone);
        if (!preg_match('/^09\d{9}$/', $phone)) {
            sendMessage($chat_id, "❌ شماره موبایل نامعتبر است. باید 11 رقم و با 09 شروع شود.\nمثال درست: 09123456789\nلطفاً دوباره وارد کنید:", getCancelMenu());
            return;
        }
        upsertUserField($chat_id, 'phone', $phone);
    
        setUserState($chat_id, $state['current_state']==='fill_phone_payment' ? 'fill_address_payment' : 'fill_address');
        sendMessage($chat_id, "✅ شماره ثبت شد.\nحالا <b>آدرس کامل</b> را وارد کنید:", getCancelMenu());
        return;
    }
    
    // مرحله آدرس
    if ($state && in_array($state['current_state'], ['fill_address','fill_address_payment'])) {
        $address = trim($text);
        if (mb_strlen($address, 'UTF-8') < 10) {
            sendMessage($chat_id, "❌ آدرس خیلی کوتاه است. لطفاً کامل‌تر وارد کنید (حداقل ۱۰ کاراکتر):", getCancelMenu());
            return;
        }
        upsertUserField($chat_id, 'address', $address);
    
        setUserState($chat_id, $state['current_state']==='fill_address_payment' ? 'fill_postal_payment' : 'fill_postal');
        sendMessage($chat_id, "✅ آدرس ثبت شد.\nحالا <b>کد پستی</b> را وارد کنید (۱۰ رقم):", getCancelMenu());
        return;
    }
    
    // مرحله کد پستی
    if ($state && in_array($state['current_state'], ['fill_postal','fill_postal_payment'])) {
        $postal = faToEnNumbers($text);
        $postal = preg_replace('/\D+/', '', $postal);
    
        if (!preg_match('/^\d{10}$/', $postal)) {
            sendMessage($chat_id, "❌ کدپستی باید دقیقاً ۱۰ رقم باشد.\nلطفاً دوباره وارد کنید:");
            return;
        }
    
        upsertUserField($chat_id, 'postal_code', $postal);
        completeUser($chat_id);
        clearUserState($chat_id);
    
        if ($state['current_state'] === 'fill_postal_payment') {
            // مستقیم برو به روند پرداخت
            processPayment($chat_id);
            return;
        }
    
        sendMessage($chat_id, "✅ مشخصات شما با موفقیت ثبت شد.", getMainMenu());
        return;
    }


    // اگر در حالت جستجو هستیم، ورودی کاربر را به عنوان کوئری جستجو بگیر
    if ($state && $state['current_state'] === 'search_product') {
        // اگر متن یکی از دکمه‌های اصلی منو بود، state کاربر رو پاک کن
        $mainMenuButtons = ["🛒 سبد خرید", "👕 لیست محصولات", "📦 پیگیری سفارشات", "👤 مشخصات من", "🔍 جستجوی محصول"];
        if (in_array($text, $mainMenuButtons)) {
            clearUserState($chat_id);
        }

        $query = trim($text);
        if (mb_strlen($query, 'UTF-8') < 2) {
            sendMessage($chat_id, "❌ عبارت جستجو خیلی کوتاه است. لطفاً حداقل ۲ کاراکتر وارد کنید:");
            return;
        }
        // نمایش نتایج صفحه 1
        showSearchResults($chat_id, $query, 1);
        return;
    }

    // اضافه کردن قبل از if ($text == "/start")
$cleanText = trim(str_replace("/start", "", $text));

if (strpos($cleanText, "product_") !== false) {
    $product_id = str_replace("product_", "", $cleanText);

    $productInfo = getProductById($product_id);
    $details = getProductDetails($product_id);

    if ($productInfo && $details) {
        $allColors = [];
        $allSizes = [];
        $allPrices = [];
        $images = [];

        foreach ($details as $v) {
            if (!in_array($v['Color'], $allColors)) $allColors[] = $v['Color'];
            foreach ($v['Sizes'] as $s) if (!in_array($s, $allSizes)) $allSizes[] = $s;
            if (!in_array($v['Price'], $allPrices)) $allPrices[] = $v['Price'];

            if (!empty($v['Image'])) $images[] = "https://tootfarangi.co" . $v['Image'];
        }

        sort($allSizes);
        sort($allPrices);

        $priceText = count($allPrices) > 1
            ? "از " . number_format(min($allPrices)) . " تا " . number_format(max($allPrices))
            : number_format($allPrices[0]);

        $msg = "🔹 <b>{$productInfo['Name']} (ID: {$product_id})</b>\n\n";
        $msg .= "🔹 <b>توضیحات: </b>\n";
        if (!empty($productInfo['Description'])) {
            $msg .= cleanDescription($productInfo['Description']) . "\n\n";
        }
        $msg .= "\n\u{200F}<b>────────────  ✦  ────────────</b>\n\n";
        $msg .= "🔹 <b>مشخصات: </b>\n";
        $msg .= "<b>رنگ‌ها:</b> " . implode(", ", $allColors) . "\n";
        $msg .= "<b>سایزها:</b> " . implode(", ", $allSizes) . "\n";
        $msg .= "<b>قیمت:</b> {$priceText} تومان";

        $keyboard = [
            'inline_keyboard' => [
                [['text' => '➕ افزودن به سبد خرید', 'callback_data' => "addcart_$product_id"]]
            ]
        ];

        // ارسال عکس اول با دکمه inline
        if (!empty($images)) {
            sendPhoto($chat_id, $images[0], $msg, $keyboard);
        } else {
            // اگر محصول عکس نداشت، فقط متن و دکمه ارسال شود
            sendMessage($chat_id, $msg, $keyboard);
        }

    } else {
        sendMessage($chat_id, "جزئیات محصول یافت نشد!");
    }

    return; // جلوگیری از اجرای کد بعدی
}
elseif (strpos($data, "category_") === 0) {
    $category_id = str_replace("category_", "", $data);
    $page = 1; // شروع از صفحه 1

    showProductsByCategory($chat_id, $category_id, $page); // تابع برای نمایش محصولات هر دسته
    return;
}




    if ($text == "/start") {
        sendMessage($chat_id, "سلام! به فروشگاه توت فرنگی خوش آمدی 🍓", getMainMenu());
    }
    // دریافت و نمایش دسته‌بندی‌ها
    elseif ($text == "👕 دسته بندی محصولات") {
        $categories = getCategories(); // گرفتن دسته‌بندی‌ها از API
    
        logToFile("Categories fetched: " . print_r($categories, true));
    
        if (!$categories) {
            sendMessage($chat_id, "❌ خطا در دریافت دسته‌بندی‌ها.");
            return;
        }
    
        // ایجاد سه گروه اصلی دسته‌بندی‌ها
        $maleCategories = [];
        $femaleCategories = [];
        $kidsCategories = [];
    
        // تقسیم دسته‌بندی‌ها به سه گروه
        foreach ($categories as $category) {
            if ($category['Gender'] == 'مردانه') {
                $maleCategories[] = $category;
            } elseif ($category['Gender'] == 'زنانه') {
                $femaleCategories[] = $category;
            } elseif ($category['Gender'] == 'بچگانه') {
                $kidsCategories[] = $category;
            }
        }
    
        // ایجاد کیبورد برای نمایش دسته‌بندی‌ها
        $keyboard = ['inline_keyboard' => []];
    
        // نمایش دسته‌بندی‌های مردانه
        if (!empty($maleCategories)) {
            $keyboard['inline_keyboard'][] = [['text' => '👨‍🦰 مردانه', 'callback_data' => 'male_categories']];
        }
        // نمایش دسته‌بندی‌های زنانه
        if (!empty($femaleCategories)) {
            $keyboard['inline_keyboard'][] = [['text' => '👩‍🦰 زنانه', 'callback_data' => 'female_categories']];
        }
        // نمایش دسته‌بندی‌های بچه‌گانه
        if (!empty($kidsCategories)) {
            $keyboard['inline_keyboard'][] = [['text' => '👶 بچه‌گانه', 'callback_data' => 'kids_categories']];
        }
    
        // ارسال پیام با کیبورد دسته‌بندی‌ها
        sendMessage($chat_id, "لطفاً یک گروه دسته‌بندی انتخاب کنید:", $keyboard);
        return;
    }

    elseif ($text == "🛒 سبد خرید") {
        $items = getCartItems($chat_id);
        if (empty($items)) {
            sendMessage($chat_id, "سبد خرید شما خالی است 🛍️", getMainMenu());
            return;
        }
    
        // محاسبه جمع کل و تعداد کل
        $totalPrice = 0;
        $totalQuantity = 0;
        foreach ($items as $item) {
            $totalPrice += $item['price'] * $item['quantity'];
            $totalQuantity += $item['quantity'];
        }
    
        // پیام خلاصه
        $summary = "🛒 <b>سبد خرید شما</b>\n\n";
        $summary .= "تعداد کل: <b>{$totalQuantity}</b>\n";
        $summary .= "جمع کل: <b>" . number_format($totalPrice) . " تومان</b>";
    
        $replyMenu = [
            'keyboard' => [
                ['🗑 حذف همه محصولات', '💳 پرداخت'],
                ['بازگشت به منو']
            ],
            'resize_keyboard' => true
        ];
    
        sendMessage($chat_id, $summary, $replyMenu);
    
        // پیام جدا برای هر محصول
        foreach ($items as $item) {
            $msg = "▫️ <b>{$item['product_name']}</b>\n";
            $msg .= "رنگ: {$item['color']} | سایز: {$item['size']}\n";
            $msg .= "تعداد: {$item['quantity']}\n";
            $msg .= "قیمت: " . number_format($item['price']) . " تومان\n";
    
            $keyboard = [
                'inline_keyboard' => [
                    [
                        ['text' => "❌ حذف", 'callback_data' => "remove_{$item['id']}"]
                    ]
                ]
            ];
    
            sendMessage($chat_id, $msg, $keyboard);
        }
    }
    elseif ($text == "🗑 حذف همه محصولات") {
        $stmt = $db->prepare("DELETE FROM cart WHERE telegram_id = ?");
        $stmt->execute([$chat_id]);
        sendMessage($chat_id, "تمام محصولات از سبد خرید شما حذف شدند.", getMainMenu());
    }
    elseif ($text == "💳 پرداخت") {
        if (isUserCompleted($chat_id)) {
            $userInfo = getUserInfo($chat_id);
            $summary = "📋 مشخصات فعلی شما:\n\n";
            $summary .= "👤 نام: {$userInfo['name']}\n";
            $summary .= "📞 تلفن: {$userInfo['phone']}\n";
            $summary .= "🏠 آدرس: {$userInfo['address']}\n";
            $summary .= "📮 کد پستی: {$userInfo['postal_code']}\n\n";
            $summary .= "آیا این اطلاعات صحیح است؟";
    
            $keyboard = [
                'inline_keyboard' => [
                    [['text' => 'بله ✅', 'callback_data' => 'confirm_user_info']],
                    [['text' => '✏️ ویرایش مشخصات', 'callback_data' => 'edit_user_info']]
                ]
            ];
    
            sendMessage($chat_id, $summary, $keyboard);
            return;
        }
    
        // حالت پرداخت → استیت جدید
        setUserState($chat_id, 'fill_name_payment');
        sendMessage($chat_id, "⚙️ شروع ثبت اطلاعات برای پرداخت\n\nلطفاً <b>نام و نام خانوادگی</b> خود را وارد کنید:", getCancelMenu());
        return;
    }

    else if ($text == "👤 مشخصات من") {
        $userInfo = getUserInfo($chat_id);
    
        if ($userInfo && $userInfo['name'] && $userInfo['phone'] && $userInfo['address'] && $userInfo['postal_code']) {
            $msg = "✅ مشخصات شما ثبت شده است:\n\n";
            $msg .= "👤 نام: {$userInfo['name']}\n";
            $msg .= "📞 تلفن: {$userInfo['phone']}\n";
            $msg .= "🏠 آدرس: {$userInfo['address']}\n";
            $msg .= "📮 کد پستی: {$userInfo['postal_code']}";
            
            $keyboard = [
                'inline_keyboard' => [
                    [['text' => '✏️ ویرایش مشخصات', 'callback_data' => 'edit_user_info']]
                ]
            ];
            
            sendMessage($chat_id, $msg, $keyboard);
        } else {
            // استفاده از همان استیت‌های پرداخت
            setUserState($chat_id, 'fill_name');
            sendMessage($chat_id, "👤 لطفاً نام و نام خانوادگی خود را وارد کنید:", getCancelMenu());
        }
        return;
    }

    elseif ($text == "بازگشت به منو") {
        clearUserState($chat_id);
        sendMessage($chat_id, "منوی اصلی:", getMainMenu());
        return;
    }
    // پیگیری سفارشات
    else if ($text == "📦 پیگیری سفارشات") {
        clearUserState($chat_id); // خروج از هر state قبلی
        sendUserOrders($chat_id);
        return;
    }

    elseif ($text == "🔍 جستجوی محصول") {
        setUserState($chat_id, 'search_product'); // می‌بریمش به حالت جستجو
        sendMessage($chat_id, "لطفاً نام کامل یا بخشی از نام محصول مورد نظر را وارد کنید:", getMainMenu());
        return;
    }
    else {
        // فقط وقتی جستجو انجام بده که داخل مراحل ثبت مشخصات نباشیم
        $infoStates = ['fill_name', 'fill_phone', 'fill_address', 'fill_postal', 'enter_name'];
        if ($state && in_array($state['current_state'], $infoStates)) {
            return; // کاری نکن
        }
    
        // جستجوی محصول
        $page = 1;
        showSearchResults($chat_id, $text, $page);
    }

}

elseif ($callback) {
    $chat_id = $callback['message']['chat']['id'];
    $data = $callback['data'];
    
    logToFile("Received callback data: $data");

    // انتخاب دسته‌بندی‌های مردانه
    // انتخاب دسته‌بندی‌های مردانه
    if ($data == 'male_categories') {
        logToFile("Fetching and displaying male categories");
        $maleCategories = getCategoriesByGender('مردانه'); // گرفتن دسته‌بندی‌های مردانه
        showCategoryProducts($chat_id, $maleCategories);  // نمایش دسته‌بندی‌ها
    }

    // انتخاب دسته‌بندی‌های زنانه
    elseif ($data == 'female_categories') {
        logToFile("Processing female categories");
        $femaleCategories = getCategoriesByGender('زنانه'); // گرفتن دسته‌بندی‌های زنانه
        showCategoryProducts($chat_id, $femaleCategories);
        return;
    }
    
    // انتخاب دسته‌بندی‌های بچه‌گانه
    elseif ($data == 'kids_categories') {
        logToFile("Processing kids categories");
        $kidsCategories = getCategoriesByGender('بچگانه'); // گرفتن دسته‌بندی‌های بچه‌گانه
        showCategoryProducts($chat_id, $kidsCategories);
        return;
    }

    if ($data == 'edit_profile') {
        sendMessage($chat_id, "لطفاً مشخصات جدید را به این شکل وارد کنید:\n\nنام - شماره - آدرس - کدپستی");
    }

    if ($data == 'confirm_add') {
        $state = getUserState($chat_id);
    
        $variations = getProductDetails($state['last_product_id']);
        $variation = findVariation($variations, $state['selected_color'], $state['selected_size']);
    
        if ($variation && isset($variation['Count']) && $variation['Count'] > 0) {
            $finalPrice = $variation['final']; // قیمت نهایی
    
            $ok = addToCart(
                $chat_id,
                $state['last_product_id'],
                $variation['Id'],
                $state['selected_color'],
                $state['selected_size'],
                1,
                $finalPrice // قیمت واحد
            );
    
            if ($ok) {
                clearUserState($chat_id);
                deleteMessage($chat_id, $callback['message']['message_id']);
                sendMessage($chat_id, "محصول با قیمت " . number_format($finalPrice) . " تومان به سبد خرید اضافه شد ✅", getMainMenu());
            } else {
                sendMessage($chat_id, "خطا در افزودن به سبد خرید.", getMainMenu());
            }
        } else {
            sendMessage($chat_id, "این محصول دیگر موجود نیست ❌", getMainMenu());
        }
    }
    
    if ($data == 'cancel_add') {
        clearUserState($chat_id);
        deleteMessage($chat_id, $callback['message']['message_id']); 
        showProductsPage($chat_id, 1);
        sendMessage($chat_id, "به منوی اصلی برگشتید.", getMainMenu());
    }

    if (strpos($data, "page_") === 0) {
        $new_page = (int)str_replace("page_", "", $data);
        showProductsPage($chat_id, $new_page);
    }
    
    if (strpos($data, "category_") === 0) {
        $category_id = str_replace("category_", "", $data);
        $page = 1; // شروع از صفحه 1
        if (strpos($data, "_page_") !== false) {
            $page = (int)str_replace("category_{$category_id}_page_", "", $data); // دریافت صفحه از callback
        }
        showProductsByCategory($chat_id, $category_id, $page); // نمایش محصولات دسته‌بندی
    }


    if (strpos($data, "product_") === 0) {
        $product_id = str_replace("product_", "", $data);
        $productInfo = getProductById($product_id);
        $details = getProductDetails($product_id);
    
        if ($productInfo && $details) {
            $allColors = [];
            $allSizes = [];
            $allPrices = [];
            $images = [];
    
            foreach ($details as $v) {
                if (!in_array($v['Color'], $allColors)) $allColors[] = $v['Color'];
                foreach ($v['Sizes'] as $s) if (!in_array($s, $allSizes)) $allSizes[] = $s;
                if (!in_array($v['Price'], $allPrices)) $allPrices[] = $v['Price'];
    
                if (!empty($v['Image'])) {
                    $images[] = "https://tootfarangi.co" . $v['Image'];
                }
            }
            
            sort($allSizes, SORT_NUMERIC);
            sort($allPrices);
            $priceText = (count($allPrices) > 1)
                ? "از " . number_format(min($allPrices)) . " تا " . number_format(max($allPrices))
                : number_format($allPrices[0]);
    
            // پیام مشخصات محصول
            $msg = "🔹 <b>{$productInfo['Name']} (ID: {$product_id})</b>\n\n";
            $msg .= "🔹 <b>توضیحات: </b>\n";
            if (!empty($productInfo['Description'])) {
                $description = cleanDescription($productInfo['Description']);
                $msg .= "$description\n\n";
            }
            $msg .= "\n\u{200F}<b>────────────  ✦  ────────────</b>\n\n";
            $msg .= "🔹 <b>مشخصات: </b>\n";
            $msg .= "<b>رنگ‌ها:</b> " . implode(", ", $allColors) . "\n";
            $msg .= "<b>سایزها:</b> " . implode(", ", $allSizes) . "\n";
            $msg .= "<b>قیمت:</b> {$priceText} تومان";
    
            // دکمه افزودن به سبد خرید
            $keyboard = [
                'inline_keyboard' => [
                    [['text' => '➕ افزودن به سبد خرید', 'callback_data' => "addcart_$product_id"]]
                ]
            ];
    
            // 🔹 اول عکس‌ها
            if (!empty($images)) {
                $media = [];
                foreach ($images as $i => $img) {
                    $media[] = [
                        'type' => 'photo',
                        'media' => $img
                    ];
                }
                sendMediaGroup($chat_id, $media);
            }
    
            // 🔹 بعد مشخصات + دکمه
            sendMessage($chat_id, $msg, $keyboard);
    
        } else {
            sendMessage($chat_id, "جزئیات محصول یافت نشد!");
        }
    }


    if (strpos($data, "addcart_") === 0) {
        $product_id = str_replace("addcart_", "", $data);
        $details = getProductDetails($product_id);
    
        if ($details && is_array($details)) {
            $colorSizesMap = []; 
            foreach ($details as $var) {
                $c = trim($var['Color']);
                if ($c) {
                    if (!isset($colorSizesMap[$c])) $colorSizesMap[$c] = [];
                    foreach ($var['Sizes'] as $s) {
                        $s = trim($s);
                        if ($s && !in_array($s, $colorSizesMap[$c])) $colorSizesMap[$c][] = $s;
                    }
                }
            }
    
            $colors = array_keys($colorSizesMap);
            if (empty($colors)) {
                sendMessage($chat_id, "این محصول متغیر فعال (رنگ/سایز) ندارد و قابل سفارش نیست.");
                return;
            }
    
            // ذخیره وضعیت کاربر
            setUserState($chat_id, 'select_color', $product_id, json_encode($colorSizesMap));
    
            // ساخت کیبورد رنگ‌ها
            $keyboard = array_chunk($colors, 2);
    
            // اضافه کردن دکمه بازگشت
            $keyboard[] = ["🔙 بازگشت"];
    
            sendMessage(
                $chat_id, 
                "لطفاً رنگ مورد نظر را انتخاب کنید:", 
                ['keyboard' => $keyboard, 'resize_keyboard' => true, 'one_time_keyboard' => false]
            );
        } else {
            sendMessage($chat_id, "مشکلی در دریافت اطلاعات محصول پیش اومد!");
        }
    }

    if (strpos($data, "remove_") === 0) {
        $cart_id = str_replace("remove_", "", $data);
    
        // گرفتن تعداد فعلی
        $stmt = $db->prepare("SELECT quantity FROM cart WHERE id = ? AND telegram_id = ?");
        $stmt->execute([$cart_id, $chat_id]);
        $quantity = $stmt->fetchColumn();
    
        if ($quantity > 1) {
            // کم کردن یکی
            $stmt = $db->prepare("UPDATE cart SET quantity = quantity - 1 WHERE id = ? AND telegram_id = ?");
            $stmt->execute([$cart_id, $chat_id]);
            sendMessage($chat_id, "یک عدد از این محصول از سبد خرید کم شد.", getMainMenu());
        } else {
            // حذف کامل
            $stmt = $db->prepare("DELETE FROM cart WHERE id = ? AND telegram_id = ?");
            $stmt->execute([$cart_id, $chat_id]);
            sendMessage($chat_id, "محصول از سبد خرید حذف شد.", getMainMenu());
        }
    }
    if (strpos($data, "search_") === 0) {
        // فرمت: search_<query>_<page>
        $parts = explode("_", $data, 3);
        $query = isset($parts[1]) ? urldecode($parts[1]) : '';
        $new_page = isset($parts[2]) ? (int)$parts[2] : 1;
        if ($query === '') {
            sendMessage($chat_id, "❌ عبارت جستجو نامعتبر است.");
            return;
        }
        showSearchResults($chat_id, $query, $new_page);
        return;
    }
    if (strpos($data, "order_details_") === 0) {
        $orderId = str_replace("order_details_", "", $data);
        sendOrderDetails($chat_id, $orderId);
    }

    if ($data == 'confirm_user_info') {
        processPayment($chat_id);
        return;
    }
    if ($data == 'edit_user_info') {
        setUserState($chat_id, 'fill_name');
        sendMessage($chat_id, "✏️ لطفاً نام و نام خانوادگی جدید خود را وارد کنید:", getCancelMenu());
        return;
    }

}

function showProductsPage($chat_id, $page = 1) {
    $products = getProducts($page, 10);
    if ($products['Code'] == 1) {
        $keyboard = ['inline_keyboard' => []];
        foreach ($products['Result']['List'] as $p) {
            $keyboard['inline_keyboard'][] = [['text' => "{$p['Name']}", 'callback_data' => "product_{$p['Id']}"]];
        }
        $nav_buttons = [];
        if ($page > 1) $nav_buttons[] = ['text' => "⬅️ قبلی", 'callback_data' => "page_" . ($page - 1)];
        if ($page * 10 < $products['Result']['Count']) $nav_buttons[] = ['text' => "بعدی ➡️", 'callback_data' => "page_" . ($page + 1)];
        if ($nav_buttons) $keyboard['inline_keyboard'][] = $nav_buttons;

        sendMessage($chat_id, "📄 صفحه $page از محصولات:", $keyboard);
    } else {
        sendMessage($chat_id, "مشکلی در دریافت محصولات پیش اومد!");
    }
}

function showSearchResults($chat_id, $query, $page = 1) {
    $resp = searchProductsByName($query, $page, 10);
    if (!$resp || $resp['Code'] != 1) {
        sendMessage($chat_id, "❌ خطا در دریافت نتایج جستجو.");
        return;
    }

    $list = $resp['Result']['List'] ?? [];
    $count = $resp['Result']['Count'] ?? 0;

    if (empty($list)) {
        sendMessage($chat_id, "هیچ محصولی برای «<b>$query</b>» پیدا نشد.", getMainMenu());
        return;
    }

    $kb = ['inline_keyboard' => []];
    foreach ($list as $p) {
        $kb['inline_keyboard'][] = [
            ['text' => $p['Name'], 'callback_data' => "product_{$p['Id']}"]
        ];
    }

    // ناوبری صفحات
    $nav = [];
    if ($page > 1) {
        $nav[] = ['text' => "⬅️ قبلی", 'callback_data' => "search_" . urlencode($query) . "_" . ($page - 1)];
    }
    if ($page * 10 < $count) {
        $nav[] = ['text' => "بعدی ➡️", 'callback_data' => "search_" . urlencode($query) . "_" . ($page + 1)];
    }
    if (!empty($nav)) $kb['inline_keyboard'][] = $nav;

    sendMessage(
        $chat_id,
        "نتایج جستجو برای: <b>$query</b>\nصفحه <b>$page</b>",
        $kb
    );
}


