<?php
require 'functions.php';

// حذف محصولات قدیمی تر از یک هفته
deleteOldProducts();

// گرفتن لیست محصولات
$products = getProducts(1, 100);

// انتخاب محصول رندوم
$product = $products['Result']['List'][array_rand($products['Result']['List'])];
$product_id = $product['Id'];

// بررسی اینکه آیا این محصول قبلاً ارسال شده است
while (isProductSent($product_id)) {
    // اگر محصول قبلاً ارسال شده باشد، یک محصول جدید انتخاب می‌کنیم
    $product = $products['Result']['List'][array_rand($products['Result']['List'])];
    $product_id = $product['Id'];
}

// 🔴 اصلاح: گرفتن اطلاعات کامل محصول
$productInfo = getProductById($product_id);
if (!$productInfo) {
    die("خطا در دریافت اطلاعات کامل محصول!");
}

// جزئیات محصول
$details = getProductDetails($product_id);

// عکس اول محصول
$photo = '';
foreach ($details as $v) {
    if (!empty($v['Image'])) {
        $photo = "https://tootfarangi.co" . $v['Image'];
        break;
    }
}
if (!$photo) die("محصول هیچ عکسی ندارد!");

// جمع‌آوری مشخصات محصول
$allColors = [];
$allSizes = [];
foreach ($details as $v) {
    if (!in_array($v['Color'], $allColors)) $allColors[] = $v['Color'];
    foreach ($v['Sizes'] as $s) if (!in_array($s, $allSizes)) $allSizes[] = $s;
}
sort($allSizes);

// 📝 لاگ برای بررسی توضیحات
file_put_contents(__DIR__ . "/story_log.txt",
    "---- شروع بررسی محصول ----\n" .
    "product_id: " . $product_id . "\n" .
    "Name: " . $productInfo['Name'] . "\n" .
    "Description raw: " . var_export($productInfo['Description'], true) . "\n" .
    "---- پایان بررسی ----\n\n",
    FILE_APPEND
);

// متن کپشن با تمام جزئیات (با استفاده از productInfo)
$caption  = "<b>{$productInfo['Name']}</b>\n\n";

if (!empty($productInfo['Description'])) {
    $caption .= "🔹 توضیحات: " . cleanDescription($productInfo['Description']) . "\n\n";
}

$caption .= "🔹 مشخصات:\n";
$caption .= "رنگ‌ها: " . implode(", ", $allColors) . "\n";
$caption .= "سایزها: " . implode(", ", $allSizes);

// دکمه inline → لینک به بات
$keyboard = [
    'inline_keyboard' => [
        [['text' => 'سفارش محصول', 'url' => "https://t.me/tootfarangiCloths_bot?start=product_$product_id"]]
    ]
];


// ارسال عکس اول با کپشن و دکمه inline
sendPhoto(CHAT_ID, $photo, $caption, $keyboard);

// ذخیره آیدی محصول در دیتابیس
logSentProduct($product_id);  // ذخیره محصول ارسال شده در جدول

echo "استوری محصول ارسال شد!";
?>