<?php
header('Content-Type: application/json; charset=utf-8');

// تنظیمات API
define('API_BASE', 'https://tootfarangi.co/api/');

function getProductDetails($id) {
    $url = API_BASE."Variations/$id";
    return json_decode(file_get_contents($url), true)['Result'] ?? null;
}

function checkStock($product_id) {
    $variations = getProductDetails($product_id);
    if (!$variations) {
        echo json_encode(['success' => false, 'message' => 'محصول یافت نشد یا API در دسترس نیست.'], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        return;
    }

    $result = [];
    foreach ($variations as $v) {
        $result[] = [
            'variation_id' => $v['Id'],
            'color' => $v['Color'],
            'sizes' => $v['Sizes'],
            'price' => $v['Price'],
            'discount_price' => $v['DiscountPrice'],
            'count' => $v['Count'],
            'image' => $v['Image']
        ];
    }

    echo json_encode(['success' => true, 'product_id' => $product_id, 'variations' => $result], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

// ----------- تست -----------
// اینجا آیدی محصول رو بزار
checkStock(1915);
